<?php

namespace DynamicHeartbeat\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

class Settings {
    private $plugin;

    public function __construct( $plugin ) {
        $this->plugin = $plugin;
        add_action( 'admin_init', [$this,'reg'] );
    }

	private function get_priority_weights( int $slider_value ): array {
		$userActivityWeight = 0.4;
		$serverLoadWeight = 0.3;
		$responseTimeWeight = 0.3;

		$userActivityWeight += (0.1 * $slider_value);
		$serverLoadWeight   -= (0.1 * $slider_value / 2);
		$responseTimeWeight -= (0.1 * $slider_value / 2);

		return [
			'user'     => $userActivityWeight,
			'server'   => $serverLoadWeight,
			'response' => $responseTimeWeight,
		];
	}

	public function reg() {
		register_setting( $this->plugin->og, 'dfehc_heartbeat_zoom', 'floatval' );
		register_setting( $this->plugin->og, 'dfehc_priority_slider', 'intval' );
		register_setting( $this->plugin->og, 'dfehc_optimization_frequency' );
		register_setting( $this->plugin->og, 'dfhcsl_backend_heartbeat_control', 'absint' );
		register_setting( $this->plugin->og, 'dfhcsl_editor_heartbeat_control', 'absint' );
		register_setting( $this->plugin->og, 'dfhcsl_backend_heartbeat_interval', [$this,'vi'] );
		register_setting( $this->plugin->og, 'dfhcsl_editor_heartbeat_interval', [$this,'vi'] );
		register_setting( $this->plugin->og, 'dfehc_redis_server', 'sanitize_text_field' );
		register_setting( $this->plugin->og, 'dfehc_redis_port', 'intval' );
		register_setting( $this->plugin->og, 'dfehc_memcached_server', 'sanitize_text_field' );
		register_setting( $this->plugin->og, 'dfehc_memcached_port', 'intval' );
		register_setting( $this->plugin->og, 'dfehc_redis_socket', 'sanitize_text_field' );
		register_setting( $this->plugin->og, 'dfehc_disable_heartbeat', 'absint' );
		register_setting( $this->plugin->og, 'add_to_menu', 'absint' );

		add_settings_section( 'dfhcsl_heartbeat_settings_section', __('Heartbeat Control Settings','dfehc'), [$this,'shb'], $this->plugin->slug );
		add_settings_section( 'dfehc_redis_settings_section', __('Redis Settings','dfehc'), [$this,'srd'], $this->plugin->slug );
		add_settings_section( 'dfehc_memcached_settings_section', __('Memcached Settings','dfehc'), [$this,'smc'], $this->plugin->slug );
		add_settings_section( 'dfehc_optimization_schedule_section', __('Database Optimization Area (Advanced section)','dfehc'), [$this,'sop'], $this->plugin->slug );
		add_settings_section( 'dfehc_load_display_settings_section', __('Heartbeat Zoom Settings','dfehc'), '__return_false', $this->plugin->slug );
		add_settings_section( 'dfehc_priority_settings_section', __('Priority Settings','dfehc'), [$this,'spr'], $this->plugin->slug );

		add_settings_field( 'dfehc_disable_heartbeat', __('Disable Heartbeat','dfehc'), [$this,'fdis'], $this->plugin->slug, 'dfhcsl_heartbeat_settings_section' );
		add_settings_field( 'dfhcsl_backend_heartbeat_control', __('Backend Heartbeat Control','dfehc'), [$this,'fbhc'], $this->plugin->slug, 'dfhcsl_heartbeat_settings_section' );
		add_settings_field( 'dfhcsl_backend_heartbeat_interval', __('Backend Heartbeat Interval','dfehc'), [$this,'fbhi'], $this->plugin->slug, 'dfhcsl_heartbeat_settings_section' );
		add_settings_field( 'dfhcsl_editor_heartbeat_control', __('Editor Heartbeat Control','dfehc'), [$this,'fehc'], $this->plugin->slug, 'dfhcsl_heartbeat_settings_section' );
		add_settings_field( 'dfhcsl_editor_heartbeat_interval', __('Editor Heartbeat Interval','dfehc'), [$this,'fehi'], $this->plugin->slug, 'dfhcsl_heartbeat_settings_section' );
		add_settings_field( 'dfehc_redis_server', __('Redis Server','dfehc'), [$this,'frs'], $this->plugin->slug, 'dfehc_redis_settings_section' );
		add_settings_field( 'dfehc_redis_port', __('Redis Port','dfehc'), [$this,'frp'], $this->plugin->slug, 'dfehc_redis_settings_section' );
		add_settings_field( 'dfehc_redis_socket', __('Redis Unix Socket','dfehc'), [$this,'frso'], $this->plugin->slug, 'dfehc_redis_settings_section' );
		add_settings_field( 'dfehc_memcached_server', __('Memcached Server','dfehc'), [$this,'fms'], $this->plugin->slug, 'dfehc_memcached_settings_section' );
		add_settings_field( 'dfehc_memcached_port', __('Memcached Port','dfehc'), [$this,'fmp'], $this->plugin->slug, 'dfehc_memcached_settings_section' );
		add_settings_field( 'dfehc_optimization_frequency', __('DB Optimization Frequency','dfehc'), [$this,'ffq'], $this->plugin->slug, 'dfehc_optimization_schedule_section' );
		add_settings_field( 'dfehc_heartbeat_zoom', __('Heartbeat Zoom Multiplier','dfehc'), [$this,'fzm'], $this->plugin->slug, 'dfehc_load_display_settings_section' );
		add_settings_field( 'dfehc_priority_slider', __('Adjust Priority','dfehc'), [$this,'fps'], $this->plugin->slug, 'dfehc_priority_settings_section' );
	}

    public function shb() { echo '<br><p>'.esc_html__('Control the WordPress heartbeat settings for the backend and editor. Disabling or setting a long interval may affect real-time features.','dfehc').'</p>'; }
	public function srd() { echo '<p>'.esc_html__('Configure Redis settings for the plugin.','dfehc').'</p>'; }
	public function smc() { echo '<p>'.esc_html__('Configure Memcached settings for the plugin.','dfehc').'</p>'; }
	public function spr() { echo '<br><p>'.esc_html__('Adjust the priority between server performance and user activity.','dfehc').'</p>'; }

	public function sop() {
		$m = get_option( 'add_to_menu', 0 );
		echo '<br><p><strong>'.esc_html__('Use this section with care.','dfehc').'</strong> '.esc_html__('An optimized database helps your website run faster. Backup first.','dfehc').'</p>';
		
		if ( function_exists('DynamicHeartbeat\\dfehc_get_database_health_status') ) {
			$h = \DynamicHeartbeat\dfehc_get_database_health_status();
			echo '<p>' . esc_html__('Database health status: ', 'dfehc') . ' <span class="database-health-status" style="--c:' . esc_attr($h['status_color']) . ';"></span></p>';
		}

		if ( $m ) echo '<p><a href="'.esc_url(admin_url('admin.php?page=dfehc-unclogger')).'">'.esc_html__('Manually choose database optimizations','dfehc').'</a></p>';
		echo '<div>';
		echo '<p><br>'.esc_html__('Add manual database optimizations page to admin menu:','dfehc').'</p><label><input type="radio" name="add_to_menu" value="1" '.checked(1,$m,false).'> '.esc_html__('Enable','dfehc').'</label> <label><input type="radio" name="add_to_menu" value="0" '.checked(0,$m,false).'> '.esc_html__('Disable','dfehc').'</label></div>';
	}

	public function fzm() { echo '<input type="number" name="dfehc_heartbeat_zoom" value="'.esc_attr(get_option('dfehc_heartbeat_zoom',10)).'" step="0.1" /><br><p> Default "10" or "1". Applies to CPU based calculations only.'; }
	
	public function fps() {
		$slider_value = (int) get_option('dfehc_priority_slider', 0);
		$weights = $this->get_priority_weights($slider_value);
		
		$userActivityWeight = $weights['user'];
		$serverLoadWeight = $weights['server'];
		$responseTimeWeight = $weights['response'];

		$slider_html = '<div style="display:flex;align-items:center;max-width:500px;">
			<span style="padding-right:10px">'.esc_html__('Server','dfehc').'</span>
			<input type="range" id="dfehc_priority_slider" name="dfehc_priority_slider" min="-3" max="3" step="1" value="'.esc_attr($slider_value).'" style="flex-grow:1" />
			<span style="padding-left:10px">'.esc_html__('Visitor','dfehc').'</span>
		</div>';

		$display_html = '<div id="dfehc-priority-display" style="max-width:500px; margin-top:10px; opacity:0.7;">
			<p style="font-size: 10px; margin: 2px 0;">User Activity Priority: <span id="user_activity_weight_display">'.number_format($userActivityWeight, 2).'</span></p>
			<p style="font-size: 10px; margin: 2px 0;">Server Load Priority: <span id="server_load_weight_display">'.number_format($serverLoadWeight, 2).'</span></p>
			<p style="font-size: 10px; margin: 2px 0;">Response Time Priority: <span id="response_time_weight_display">'.number_format($responseTimeWeight, 2).'</span></p>
		</div>';

		echo '<div>' . $slider_html . $display_html . '</div>';
	}

	public function fdis() { echo '<input type="checkbox" name="dfehc_disable_heartbeat" value="1" '.checked(1,get_option('dfehc_disable_heartbeat'),false).' '.((get_option('dfhcsl_backend_heartbeat_control')||get_option('dfhcsl_editor_heartbeat_control'))?'disabled':'').' />'; }
	
	public function fbhc() {
        echo '<div style="display: flex; align-items: center; gap: 8px;">
            <input type="checkbox" name="dfhcsl_backend_heartbeat_control" value="1" '.checked(1, get_option('dfhcsl_backend_heartbeat_control'), false).' />
            <span class="dfehc-tooltip">?
                <span class="dfehc-tooltip-text">' . esc_html__('Enable manual heartbeat control for the backend', 'dfehc') . '</span>
            </span>
        </div>';
    }

	public function fbhi() { echo '<input type="number" name="dfhcsl_backend_heartbeat_interval" min="15" max="300" value="'.esc_attr(get_option('dfhcsl_backend_heartbeat_interval','30')).'" />'; }
	
	public function fehc() {
        echo '<div style="display: flex; align-items: center; gap: 8px;">
            <input type="checkbox" name="dfhcsl_editor_heartbeat_control" value="1" '.checked(1, get_option('dfhcsl_editor_heartbeat_control'), false).' />
            <span class="dfehc-tooltip">?
                <span class="dfehc-tooltip-text">' . esc_html__('Enable manual heartbeat control for the editor', 'dfehc') . '</span>
            </span>
        </div>';
    }

	public function fehi() { echo '<input type="number" name="dfhcsl_editor_heartbeat_interval" min="15" max="300" value="'.esc_attr(get_option('dfhcsl_editor_heartbeat_interval','30')).'" />'; }
	public function frs() { echo '<input type="text" name="dfehc_redis_server" value="'.esc_attr(get_option('dfehc_redis_server','127.0.0.1')).'" />'; }
	public function frp() { echo '<input type="number" name="dfehc_redis_port" value="'.esc_attr(get_option('dfehc_redis_port',6379)).'" />'; }
	public function frso() { echo '<input type="text" name="dfehc_redis_socket" value="'.esc_attr(get_option('dfehc_redis_socket','')).'" placeholder="/path/to/redis.sock" />'; }
	public function fms() { echo '<input type="text" name="dfehc_memcached_server" value="'.esc_attr(get_option('dfehc_memcached_server','127.0.0.1')).'" />'; }
	public function fmp() { echo '<input type="number" name="dfehc_memcached_port" value="'.esc_attr(get_option('dfehc_memcached_port',11211)).'" />'; }

	public function ffq() {
		$f = get_option('dfehc_optimization_frequency','');
		$o = [''=>__('Disabled','dfehc'),'daily'=>__('Daily','dfehc'),'weekly'=>__('Every week','dfehc'),'biweekly'=>__('Every two weeks','dfehc'),'monthly'=>__('Every month','dfehc')];
		echo '<select name="dfehc_optimization_frequency">';
		foreach ($o as $v=>$l) echo '<option value="'.esc_attr($v).'" '.selected($f,$v,false).'>'.esc_html($l).'</option>';
		echo '</select>';
	}

	public function vi($i){ if($i==='disable') return $i; $v=(int)$i; return ($v>=15&&$v<=300)?$v:60; }
}