<?php

namespace DynamicHeartbeat\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

class AssetManager {
    private $plugin;

    public function __construct( $plugin ) {
        $this->plugin = $plugin;
        add_action( 'admin_enqueue_scripts', [$this,'assets'] );
    }

	public function assets( $hook ) {
		if ( ! in_array($hook,['settings_page_dfehc_plugin','toplevel_page_dfehc-unclogger'],true) ) return;
		
		wp_enqueue_style ( 'dfhcsl-admin-css', plugin_dir_url(__FILE__).'../css/dfhcsl-admin.css',[], '1.2' );
		wp_enqueue_script( 'dfhcsl-admin-js', plugin_dir_url(__FILE__).'../js/dfhcsl-admin.js', ['jquery'], '1.2', true );
		
		$css = '
			.wrap form h2{margin-top:2em;padding-top:1.5em;border-top:1px solid #ddd}
			.wrap form h2:first-of-type{margin-top:0;padding-top:0;border-top:none}
			.collapsible-header{cursor:pointer;user-select:none}
			.collapsible-header .toggle-indicator{float:right;font-size:1.2em;line-height:1;font-weight:bold}
			#dfehc-optimizer-form button{margin-right:5px;margin-bottom:5px}
			.database-health-status{display:inline-block;width:20px;height:20px;border-radius:50%;background-color:var(--c);animation:heartbeat 1s linear infinite;box-shadow:0 0 10px var(--c)}
			@keyframes heartbeat{50%{box-shadow:0 0 25px var(--c)}}
			.dfehc-loader-overlay{display:none;position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(255,255,255,.85);z-index:9999;text-align:center}
			.dfehc-loader-content{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%)}
			.heartbeat-loader{--c:#28a745;width:60px;height:60px;border-radius:50%;background:var(--c);animation:pulse 1.5s ease-in-out infinite;box-shadow:0 0 10px var(--c),0 0 20px var(--c),0 0 30px var(--c);margin:0 auto}
			@keyframes pulse{0%,100%{transform:scale(1);box-shadow:0 0 10px var(--c),0 0 20px var(--c)}50%{transform:scale(1.25);box-shadow:0 0 25px var(--c),0 0 45px var(--c),0 0 65px var(--c)}}     
			.dfehc-tooltip {
                position: relative;
                display: inline-flex;
                align-items: center;
                justify-content: center;
                width: 15px;
                height: 15px;
                border-radius: 50%;
                background-color: #a0a5aa;
                color: #fff;
                font-size: 10px;
                font-weight: bold;
                cursor: help;
                user-select: none;
				margin-top: -2px;
            }
            .dfehc-tooltip .dfehc-tooltip-text {
                visibility: hidden;
                width: 250px;
                background-color: #333;
                color: #fff;
                text-align: center;
                border-radius: 6px;
                padding: 8px;
                position: absolute;
                z-index: 1;
                bottom: 150%;
                left: 50%;
                margin-left: -125px; /* Use half of the width to center */
                opacity: 0;
                transition: opacity 0.3s;
                font-size: 12px;
                font-weight: normal;
            }
            .dfehc-tooltip .dfehc-tooltip-text::after {
                content: "";
                position: absolute;
                top: 100%;
                left: 50%;
                margin-left: -5px;
                border-width: 5px;
                border-style: solid;
                border-color: #333 transparent transparent transparent;
            }
            .dfehc-tooltip:hover .dfehc-tooltip-text {
                visibility: visible;
                opacity: 1;
            }
            ';
		wp_add_inline_style( 'dfhcsl-admin-css', $css );

		$js = '
			jQuery(function($){
				var sectionTitles=["'.esc_js(__('Redis Settings','dfehc')).'","'.esc_js(__('Memcached Settings','dfehc')).'"];
				$("form h2").each(function(){
					var $header=$(this);
					if(sectionTitles.indexOf($header.text().trim())!==-1){
						var $contentWrapper=$("<div>",{class:"collapsible-content",style:"display:none"}).insertAfter($header);
						$header.nextUntil("h2,.submit").appendTo($contentWrapper);
						$header.addClass("collapsible-header").append(\'<span class="toggle-indicator"> +</span>\');
					}
				});

				$("body").on("click", ".collapsible-header", function(){
					var $indicator=$(this).find(".toggle-indicator");
					$(this).next(".collapsible-content").slideToggle(200,function(){
						$indicator.text($(this).is(":visible")?" -":" +");
					});
				});

				const overlay=$("<div>",{id:"dfehc-loader-overlay"}).addClass("dfehc-loader-overlay")
					.append($("<div>",{class:"dfehc-loader-content"})
					.append($("<div>",{class:"heartbeat-loader"}))
					.append($("<p>").css({marginTop:"20px",fontSize:"1.2em"}).text("'.esc_js(__('Processing, please wait…','dfehc')).'")));
				$("body").append(overlay);
				
				$("#dfehc-optimizer-form").on("submit",function(e){
					e.preventDefault();
					let task=$(document.activeElement).val();
					if(!task){alert("'.esc_js(__('Could not determine task. Please click a button to optimize.','dfehc')).'");return;}
					
					overlay.show();
					$.post(ajaxurl,{
						action:"dfehc_optimize",
						optimize_function:task,
						_ajax_nonce:"'.wp_create_nonce('dfehc_optimize_action').'"
					})
					.done(()=>location.reload())
					.fail(xhr=>{
						overlay.hide();
						alert(xhr.responseText||"'.esc_js(__('Unexpected error – check the PHP error log.','dfehc')).'");
					});
				});
			});';
		wp_add_inline_script( 'dfhcsl-admin-js', $js );
	}
}