<?php

namespace DynamicHeartbeat\Core;

if ( ! defined( 'ABSPATH' ) ) { exit; }

class HeartbeatController {
    private $plugin;

    public function __construct( $plugin ) {
        $this->plugin = $plugin;
        add_action( 'init', [$this,'maybe_disable'], 0 );
        add_filter( 'heartbeat_settings', [$this,'hb'], 20 );
        add_filter( 'dfehc_contextual_load_value', [$this,'zoom'], 10, 2 );
    }

    public function maybe_disable() {
        if ( get_option('dfehc_disable_heartbeat') )
            add_action( 'init', fn() => wp_deregister_script('heartbeat'), 100 );
    }

    public function hb( $s ) {
        $id = $_POST['screen_id'] ?? '';
        if ( strpos($id,'post') !== false && get_option('dfhcsl_editor_heartbeat_control') ) {
            $i = get_option('dfhcsl_editor_heartbeat_interval','60');
            if ( $i !== 'disable' ) $s['interval'] = $i;
        } elseif ( get_option('dfhcsl_backend_heartbeat_control') ) {
            $i = get_option('dfhcsl_backend_heartbeat_interval','60');
            if ( $i !== 'disable' ) $s['interval'] = $i;
        }
        return $s;
    }

    public function zoom( $load, $src ) {
        return $src === 'cpu_load' ? $load * (float) get_option('dfehc_heartbeat_zoom',10) : $load;
    }
}