<?php
/**
 * Background Mask Style - Rock Stack.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Rock_Stack
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Rock_Stack extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Rock Stack', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M0,1440H1920V0H0ZM1180.15,189.62c17.81-72.88,132.41-107.49,256-77.3S1645.41,226.07,1627.6,299s-132.41,107.49-256,77.3S1162.34,262.5,1180.15,189.62Zm94.73,269.2c158.35-70.73,320.55-52.34,362.27,41.07S1584.31,726.35,1426,797.08,1105.39,849.42,1063.68,756,1116.52,529.55,1274.88,458.82ZM1379.33,858.5c231.74,0,419.61,110.81,419.61,247.5s-187.87,247.5-419.61,247.5-419.6-110.81-419.6-247.5S1147.59,858.5,1379.33,858.5Z"/>',
					'portrait'  => '<path d="M0,0V2560H1920V0ZM978.86,523c30.69-125.6,228.19-185.25,441.14-133.22s360.69,196,330,321.64-228.2,185.24-441.14,133.21S948.17,648.62,978.86,523ZM1162.11,987c272.91-121.89,552.44-90.2,624.33,70.78s-91.06,390.29-364,512.18-552.44,90.2-624.33-70.78S889.19,1108.84,1162.11,987Zm84.72,1380.65c-326.39,0-591-156.07-591-348.59s264.59-348.59,591-348.59,591,156.07,591,348.59S1573.22,2367.6,1246.83,2367.6Z"/>',
					'square'    => '<path d="M0,1920H1920V0H0ZM1044.44,304.23c21.69-88.76,161.25-130.91,311.72-94.14S1611,348.61,1589.35,437.37s-161.25,130.9-311.72,94.13S1022.75,393,1044.44,304.23Zm115.35,327.83c192.86-86.13,390.38-63.74,441.18,50s-64.35,275.79-257.2,361.92-390.37,63.74-441.18-50S966.94,718.19,1159.79,632.06ZM1287,1118.79c282.22,0,511,135,511,301.41s-228.78,301.41-511,301.41S776,1586.66,776,1420.2,1004.79,1118.79,1287,1118.79Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M959.73,1106c0-136.69,187.86-247.5,419.6-247.5s419.61,110.81,419.61,247.5-187.87,247.5-419.61,247.5S959.73,1242.69,959.73,1106ZM1426,797.08c158.36-70.73,252.91-203.79,211.2-297.19s-203.92-111.8-362.27-41.07S1022,662.6,1063.68,756,1267.59,867.8,1426,797.08Zm-54.32-420.83c123.56,30.19,238.17-4.42,256-77.3s-67.92-156.44-191.48-186.63-238.16,4.42-256,77.3S1248.07,346.06,1371.63,376.25Z"/>',
					'portrait'  => '<path d="M1837.81,2019c0,192.52-264.59,348.59-591,348.59s-591-156.07-591-348.59,264.59-348.59,591-348.59S1837.81,1826.49,1837.81,2019Zm-415.35-449.1c272.92-121.89,435.88-351.2,364-512.18S1435,865.06,1162.11,987s-435.88,351.2-364,512.18S1149.55,1691.8,1422.46,1569.91Zm-113.6-725.26c212.94,52,410.45-7.61,441.14-133.21S1632.94,441.83,1420,389.8,1009.55,397.42,978.86,523,1095.92,792.62,1308.86,844.65Z"/>',
					'square'    => '<path d="M776,1420.2c0-166.46,228.78-301.41,511-301.41s511,135,511,301.41-228.78,301.41-511,301.41S776,1586.66,776,1420.2ZM1343.77,1044c192.85-86.13,308-248.17,257.2-361.92s-248.32-136.14-441.18-50S851.79,880.23,902.59,994,1150.92,1130.12,1343.77,1044ZM1277.63,531.5c150.47,36.77,290-5.38,311.72-94.13s-82.72-190.51-233.19-227.28-290,5.38-311.72,94.14S1127.16,494.74,1277.63,531.5Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M1920,1440V0H0V1440ZM304.23,875.56c-88.76-21.69-130.91-161.25-94.14-311.72S348.61,309,437.37,330.65,568.27,491.9,531.5,642.37,393,897.25,304.23,875.56ZM632.06,760.21c-86.13-192.86-63.74-390.38,50-441.18S957.86,383.38,1044,576.23s63.74,390.37-50,441.18S718.19,953.06,632.06,760.21ZM1118.79,633c0-282.22,135-511,301.41-511s301.41,228.78,301.41,511-134.95,511-301.41,511S1118.79,915.21,1118.79,633Z"/>',
					'portrait'  => '<path d="M1920,2560V0H0V2560ZM304.23,875.56c-88.76-21.69-130.91-161.25-94.14-311.72S348.61,309,437.37,330.65,568.27,491.9,531.5,642.37,393,897.25,304.23,875.56ZM632.06,760.21c-86.13-192.86-63.74-390.38,50-441.18S957.86,383.38,1044,576.23s63.74,390.37-50,441.18S718.19,953.06,632.06,760.21ZM1118.79,633c0-282.22,135-511,301.41-511s301.41,228.78,301.41,511-134.95,511-301.41,511S1118.79,915.21,1118.79,633Z"/>',
					'square'    => '<path d="M1920,1920V0H0V1920ZM304.23,875.56c-88.76-21.69-130.91-161.25-94.14-311.72S348.61,309,437.37,330.65,568.27,491.9,531.5,642.37,393,897.25,304.23,875.56ZM632.06,760.21c-86.13-192.86-63.74-390.38,50-441.18S957.86,383.38,1044,576.23s63.74,390.37-50,441.18S718.19,953.06,632.06,760.21ZM1118.79,633c0-282.22,135-511,301.41-511s301.41,228.78,301.41,511-134.95,511-301.41,511S1118.79,915.21,1118.79,633Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M304.23,875.56c-88.76-21.69-130.91-161.25-94.14-311.72S348.61,309,437.37,330.65,568.27,491.9,531.5,642.37,393,897.25,304.23,875.56ZM632.06,760.21c-86.13-192.86-63.74-390.38,50-441.18S957.86,383.38,1044,576.23s63.74,390.37-50,441.18S718.19,953.06,632.06,760.21ZM1118.79,633c0-282.22,135-511,301.41-511s301.41,228.78,301.41,511-134.95,511-301.41,511S1118.79,915.21,1118.79,633Z"/>',
					'portrait'  => '<path d="M304.23,875.56c-88.76-21.69-130.91-161.25-94.14-311.72S348.61,309,437.37,330.65,568.27,491.9,531.5,642.37,393,897.25,304.23,875.56ZM632.06,760.21c-86.13-192.86-63.74-390.38,50-441.18S957.86,383.38,1044,576.23s63.74,390.37-50,441.18S718.19,953.06,632.06,760.21ZM1118.79,633c0-282.22,135-511,301.41-511s301.41,228.78,301.41,511-134.95,511-301.41,511S1118.79,915.21,1118.79,633Z"/>',
					'square'    => '<path d="M304.23,875.56c-88.76-21.69-130.91-161.25-94.14-311.72S348.61,309,437.37,330.65,568.27,491.9,531.5,642.37,393,897.25,304.23,875.56ZM632.06,760.21c-86.13-192.86-63.74-390.38,50-441.18S957.86,383.38,1044,576.23s63.74,390.37-50,441.18S718.19,953.06,632.06,760.21ZM1118.79,633c0-282.22,135-511,301.41-511s301.41,228.78,301.41,511-134.95,511-301.41,511S1118.79,915.21,1118.79,633Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Rock_Stack();
